package abstraction;
/**
 * @author Chiara Coccia, Diego Colarullo
 * @version 1.3 09/03/18
 * @since JDK 1.6
 */

import java.util.*;


/**
 * This class has methods to get different kind of informations on a service. 
 * Constructor takes in input a content's file read using ReadFile Class
 */
public class Service {

	private HashMap<State, HashSet<Action>> listAction;
	private HashMap<StateAction, HashSet<State>> nextStates;  
	private Set<State> finalStates;
	private Set<TransitionFunction> transitions;
	private String filename;
	private State initialState;
	private boolean isDeterministic;

	/**
	 * this constructor takes content's file like  string  and build a service
	 */	
    public Service(String readingFile){
    	listAction= new HashMap<State, HashSet<Action>>();
    	nextStates =new HashMap<StateAction, HashSet<State>>();
    	
    	HashMap<String, State> stateAux=new HashMap<String, State>();
    	HashMap<String, StateAction> stateActionAux=new HashMap<String, StateAction>(); 
    	HashMap<String, Action> actionAux=new HashMap<String, Action>();     	
    	
    	
    	finalStates= new HashSet<State>();
    	transitions=new HashSet<TransitionFunction>();    
    	isDeterministic=true;
    	
		filename = readingFile.substring(0, readingFile.indexOf("?"));
    	readingFile = readingFile.substring(readingFile.indexOf("?")+1);   	
    	
    	if(!readingFile.equals("")){
    		String states = readingFile.substring(readingFile.indexOf(":")+1, readingFile.indexOf("initial:"));
    		String initialState = readingFile.substring(readingFile.indexOf("initial:")+8, readingFile.indexOf("final:"));
    		String finalState = readingFile.substring(readingFile.indexOf("final:")+6);
                	
        	//this cycle build triple presentState-action-nextState
        	while(states.length()!=0) {
        		
        		String presentStateName = states.substring(0,states.indexOf("-"));
        		states = states.substring(states.indexOf("-")+1);
        		String actionName = states.substring(0, states.indexOf("-"));
        		String nextStateName = states.substring(states.indexOf("-")+1, states.indexOf(";"));
        		TransitionFunction tf = new TransitionFunction(new State(presentStateName),new Action(actionName),new State(nextStateName));	    			
    			states = states.substring(states.indexOf(";")+1);
    			this.transitions.add(tf);
    			

    			if(!stateAux.containsKey(presentStateName)){
	    				//creation objects
	    				State  statePresent =new State(presentStateName);
	    				
	    				State  stateNext;        			
	    				if(!stateAux.containsKey(nextStateName)){
	        				stateNext =new State(nextStateName); 				
	        				
	        				stateAux.put(nextStateName, stateNext);     				
	        				listAction.put(stateNext, new HashSet<Action>());	        				
	        			}  
	    				else
	    					stateNext=stateAux.get(nextStateName);
	    			
	    				Action action;
	    				if(!actionAux.containsKey(actionName)){
	    					action=new Action(actionName);
	    					actionAux.put(actionName, action);
	    				}
	    				else
	    					action=actionAux.get(actionName);
	    				    					
	    				
	    				StateAction stateAction=new StateAction(statePresent, action); 
	    				HashSet<Action> actions= new HashSet<Action>();
	      				HashSet<State> nextStates= new HashSet<State>();
	    				
	    				//add objects into structures
	    				stateAux.put(presentStateName, statePresent);
	    				actions.add(action);
	    				nextStates.add(stateNext);
	    				
	    				stateActionAux.put((presentStateName+actionName),stateAction);
	    				listAction.put(statePresent, actions);
	    				this.nextStates.put(stateAction, nextStates);	    				
	    				
	    				if (finalState.contains(presentStateName+";")||finalState.contains(presentStateName+"."))
	    					finalStates.add(statePresent);
	    				
	    				if (finalState.contains(nextStateName+";")||finalState.contains(nextStateName+"."))
	    					finalStates.add(stateNext);
	    				
	    				if(initialState.contains(presentStateName) && !initialState.equals(null))
	    					this.initialState = statePresent;
	    				
	    				if(initialState.contains(nextStateName)  && !initialState.equals(null))
	    					this.initialState = stateNext;
    			}
    			else{
    					//creation objects
	    				State  stateNext;     				
	    				if(!stateAux.containsKey(nextStateName)){
	        				stateNext =new State(nextStateName); 				
	        				
	        				stateAux.put(nextStateName, stateNext);     				
	        				listAction.put(stateNext, new HashSet<Action>());	
	        				
	        				if (finalState.contains(nextStateName+";")||finalState.contains(nextStateName+"."))
		    					finalStates.add(stateNext);
	        			}  
	    				else
	    					stateNext=stateAux.get(nextStateName);
	    				
	    				
	    				
	    				if(initialState.contains(nextStateName) && !initialState.equals(null))
	    					this.initialState = stateNext;
	    				
	    				Action action;	    				
	    				if(!stateActionAux.containsKey((presentStateName+actionName))){
	    					State state  = stateAux.get(presentStateName);
	    					//creation objects	    					
	        				
	        				if(!actionAux.containsKey(actionName)){
	        					action=new Action(actionName);
	        					actionAux.put(actionName, action);
	        				}
	        				else
	        					action=actionAux.get(actionName);
	        				        				
	        				StateAction stateAction=new StateAction(state, action);
	    				    HashSet<State> nextStates= new HashSet<State>();
	    				    
		    				//add objects into structures	    				    
	     					stateActionAux.put((presentStateName+actionName),stateAction);  
	     					HashSet<Action> actions= listAction.get(state);
	     					
	     					actions.add(action);
	     					
	     					nextStates.add(stateNext);
		    				this.nextStates.put(stateAction, nextStates);			    				
	    				}    	
	    				else{
	    					
	    					StateAction sa=stateActionAux.get((presentStateName+actionName));
	    					HashSet<State> nextStates= this.nextStates.get(sa);
    					
	    					if(!nextStates.contains(stateNext)){    						
	    						nextStates.add(stateNext);   	    				
	    					}
	    					
	    					//if a pair present state and action is still present in state action list
	    					//and we are in else branch of the if, we have for this pair two or more next state
	    					//so our service is non deterministic
	    					isDeterministic = false;
	    				}
    			}
        	}
        	stateAux.clear();
        	stateActionAux.clear();
        	actionAux.clear();
    	}
    	
    } 
    
    /**
     * get all the triples of present state, action and next state stored from the document
     * @return a collection of transition functions
     */
	protected Set<TransitionFunction> getTransitionFunctionsSet() {
		return Collections.unmodifiableSet(this.transitions);
	}
	
	/**
	 * et all the triples of present state, action and next state stored from the document
	 * @return Iterator on transition functions
	 */	
	public Iterator<TransitionFunction> getTransitionFunctions(){
		return new OnlyReadIterator<TransitionFunction>(transitions.iterator());
	}	
	
				
	/**
	 * get all final states of Service
	 * @return Iterator on final states 
	 */	
	public Iterator<State> getFinalStates() {
		return new OnlyReadIterator<State>(this.finalStates.iterator());
	}

	/**
	 * get all final states of Service
	 * @return Set of final states 
	 */	
	//this method is used only by Cartesian Product and use the static method of Collections class 
	//returning a view of finalState set
	protected Set<State> getFinalStatesSet() {
		return Collections.unmodifiableSet(this.finalStates);
	}
	
	/**
	 * get all states of the service
	 * @return Iterator on states
	 */
	public Iterator<State> getStates(){	
		return new OnlyReadIterator<State>(this.listAction.keySet().iterator());
	}	
	
	/**
	 * This method says if a state is final or not
	 * @return boolean. True if state is final, false otherwise
	 */
	public boolean isFinalState(State state){
		return this.finalStates.contains(state);
	}     	    

	/**
	 * get the next states from a state-action 
	 * @param presentState
	 * @param action  
	 * @return Iterator on next states
	 */
	public Iterator<State> getNextStates(State presentState, Action action){
		return new OnlyReadIterator<State>(this.nextStates.get(new StateAction(presentState, action)).iterator());
	}

	
	/**
	 * say if exist a pair of state-action
	 * @param presentState to check
	 * @param action to check
	 * @return boolean. True if exist pair of present state and action, false otherwise
	 */
	public boolean containsPresentAction(State presentState, Action action){
		return  this.nextStates.containsKey(new StateAction(presentState, action));
	}

	
	
	/**
	 * get all possible action from a present state
	 * @param state from which gets actions 
	 * @return Iterator on actions
	 */
	public Iterator<Action> getActions(State state){		
		return  new OnlyReadIterator<Action>(this.listAction.get(state).iterator());
	}
	
	/**
	 * get initial state
	 * @return State
	 */
	public State getInitialState(){		
		return this.initialState;
	}

	/**
	 * says if the service is or not deterministic
	 * @return boolean
	 */
	public boolean isDeterministic(){		
		return this.isDeterministic;
	}
	
	/**
	 * get the service's name
	 * @return String containing the service's name. 
	 */
	public String getName(){
		return this.filename;
	}	
	
	/**
	 * set the service's name
	 * @param name of service
	 */
	//this method is used only by carthisian Product Class
 	protected void setName(String name){
		this.filename=name;		
	}

	public String toString() {
		//return ("\nService: "+this.filename+"\nstates=" + this.nextStates+"\nInitial State: ["+this.initialState+"]\nFinal States : "+this.finalStates+"\n");
		return filename;
	}	
}
